<!-- readme.md -->

<p align="center">
    <img src="https://ldaprecord.com/logo.svg" width="400">
</p>

<p align="center">
    <a href="https://github.com/DirectoryTree/LdapRecord/actions">
        <img src="https://img.shields.io/github/actions/workflow/status/directorytree/ldaprecord/run-tests.yml?branch=master&style=flat-square">
    </a>
    <a href="https://scrutinizer-ci.com/g/DirectoryTree/LdapRecord/?branch=master">
        <img src="https://img.shields.io/scrutinizer/g/DirectoryTree/LdapRecord/master.svg?style=flat-square"/>
    </a>
    <a href="https://packagist.org/packages/DirectoryTree/LdapRecord">
        <img src="https://img.shields.io/packagist/dt/DirectoryTree/LdapRecord.svg?style=flat-square"/>
    </a>
    <a href="https://packagist.org/packages/DirectoryTree/LdapRecord">
        <img src="https://img.shields.io/packagist/v/DirectoryTree/LdapRecord.svg?style=flat-square"/>
    </a>
    <a href="https://packagist.org/packages/DirectoryTree/LdapRecord">
        <img src="https://img.shields.io/github/license/DirectoryTree/LdapRecord.svg?style=flat-square"/>
    </a>
</p>

<p align="center">
    Working with LDAP doesn't need to be hard.
</p>

<p align="center">
    LdapRecord is a fully-featured <a href="https://en.wikipedia.org/wiki/Active_record_pattern">Active Record</a>
    ORM that makes working with LDAP directories a breeze 🍃
</p>

<h4 align="center">
    <a href="https://ldaprecord.com/docs/core/v2/quickstart/">Quickstart</a>
    <span> · </span>
    <a href="https://ldaprecord.com/docs/core/v2/">Documentation</a>
    <span> · </span>
    <a href="https://github.com/DirectoryTree/LdapRecord-Laravel">Laravel Integration</a>
    <span> · </span>
    <a href="https://github.com/DirectoryTree/LdapRecord/discussions/new">Post a Question</a>
</h4>

---

⏲ **Up and Running Fast**

Connect to your LDAP servers and start running queries in a matter of minutes.

💡 **Fluent Filter Builder**

Find the LDAP objects you're looking for with a fluent LDAP filter builder.

💼 **Multi-Domain Ready**

Built-in connection management allows you to access multiple domains without breaking a sweat.

🔥 **Supercharged Active Record**

Create and modify LDAP objects with minimal code.

---

<h3 align="center">
Active Directory Features
</h3>

🚪 **Enable / Disable Accounts**

Detect and assign User Account Control values on accounts with the fluent [Account Control builder](https://ldaprecord.com/docs/core/v2/active-directory/users/#uac).

🔑 **Reset / Change Passwords**

Built-in support for [changing](https://ldaprecord.com/docs/core/v2/active-directory/users/#changing-passwords) and [resetting](https://ldaprecord.com/docs/core/v2/active-directory/users/#resetting-passwords) passwords on Active Directory accounts.

🗑 **Restore Deleted Objects**

We've all been there -- accidentally deleting a user or group in Active Directory. [Restore them](https://ldaprecord.com/docs/core/v2/models/#restoring-deleted-models) by seamlessly accessing your directory's recycle bin.

---

<h3 align="center">LdapRecord is Supportware™</h3>

<p align="center">If you require support using LdapRecord, a <a href="https://github.com/sponsors/stevebauman">sponsorship</a> is required :pray:</p>

<p align="center">Thank you for your understanding :heart:</p>

--- 

<h3 align="center">Security Vulnerabilities</h3>

<p align="center">If you discover a security vulnerability within LdapRecord, please send an e-mail to Steve Bauman via <a href="mailto:steven_bauman@outlook.com">steven_bauman@outlook.com</a>.</p>

<p align="center">All security vulnerabilities will be promptly addressed.</p>

---

<h3 align="center">Credits</h3>

<p align="center">This package is directly inspired from <a href="https://laravel.com/docs/eloquent">Laravel's Eloquent</a>, and most features are direct ports to an LDAP equivalent.</p>

<p align="center">I am forever grateful for the work <a href="https://github.com/taylorotwell">Taylor Otwell</a> has produced.</p>

<p align="center">If you can, support his work by purchasing a <a href="https://github.com/sponsors/taylorotwell">sponsorship</a>, or one of his many Laravel based services.</p>
